<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkSecurity;

class AuthzPolicyAuthzRulePrincipal extends \Google\Model
{
  protected $principalType = AuthzPolicyAuthzRuleStringMatch::class;
  protected $principalDataType = '';
  /**
   * @var string
   */
  public $principalSelector;

  /**
   * @param AuthzPolicyAuthzRuleStringMatch
   */
  public function setPrincipal(AuthzPolicyAuthzRuleStringMatch $principal)
  {
    $this->principal = $principal;
  }
  /**
   * @return AuthzPolicyAuthzRuleStringMatch
   */
  public function getPrincipal()
  {
    return $this->principal;
  }
  /**
   * @param string
   */
  public function setPrincipalSelector($principalSelector)
  {
    $this->principalSelector = $principalSelector;
  }
  /**
   * @return string
   */
  public function getPrincipalSelector()
  {
    return $this->principalSelector;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AuthzPolicyAuthzRulePrincipal::class, 'Google_Service_NetworkSecurity_AuthzPolicyAuthzRulePrincipal');
