<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ReservationBlockHealthInfo extends \Google\Model
{
  /**
   * @var int
   */
  public $degradedSubBlockCount;
  /**
   * @var string
   */
  public $healthStatus;
  /**
   * @var int
   */
  public $healthySubBlockCount;

  /**
   * @param int
   */
  public function setDegradedSubBlockCount($degradedSubBlockCount)
  {
    $this->degradedSubBlockCount = $degradedSubBlockCount;
  }
  /**
   * @return int
   */
  public function getDegradedSubBlockCount()
  {
    return $this->degradedSubBlockCount;
  }
  /**
   * @param string
   */
  public function setHealthStatus($healthStatus)
  {
    $this->healthStatus = $healthStatus;
  }
  /**
   * @return string
   */
  public function getHealthStatus()
  {
    return $this->healthStatus;
  }
  /**
   * @param int
   */
  public function setHealthySubBlockCount($healthySubBlockCount)
  {
    $this->healthySubBlockCount = $healthySubBlockCount;
  }
  /**
   * @return int
   */
  public function getHealthySubBlockCount()
  {
    return $this->healthySubBlockCount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ReservationBlockHealthInfo::class, 'Google_Service_Compute_ReservationBlockHealthInfo');
