<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\APIhub;

class GoogleCloudApihubV1ApiKeyConfig extends \Google\Model
{
  protected $apiKeyType = GoogleCloudApihubV1Secret::class;
  protected $apiKeyDataType = '';
  /**
   * @var string
   */
  public $httpElementLocation;
  /**
   * @var string
   */
  public $name;

  /**
   * @param GoogleCloudApihubV1Secret
   */
  public function setApiKey(GoogleCloudApihubV1Secret $apiKey)
  {
    $this->apiKey = $apiKey;
  }
  /**
   * @return GoogleCloudApihubV1Secret
   */
  public function getApiKey()
  {
    return $this->apiKey;
  }
  /**
   * @param string
   */
  public function setHttpElementLocation($httpElementLocation)
  {
    $this->httpElementLocation = $httpElementLocation;
  }
  /**
   * @return string
   */
  public function getHttpElementLocation()
  {
    return $this->httpElementLocation;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApihubV1ApiKeyConfig::class, 'Google_Service_APIhub_GoogleCloudApihubV1ApiKeyConfig');
